﻿using System;
using System.Globalization;
using System.Threading;

namespace Localization
{
    public partial class TransactionsWithFilters : System.Web.UI.Page
    {

        protected override void InitializeCulture()
        {
            base.InitializeCulture();
            if (Request.Form["CultureSelectorDropDown"] != null)
            {
                CultureInfo newCulture = CultureInfo.CreateSpecificCulture(Request.Form["CultureSelectorDropDown"]);

                // enables different culture info (date formats, currency formats)
                Thread.CurrentThread.CurrentCulture = newCulture;

                // enables different resource files (i.e. resources.es-mx.resx)
                Thread.CurrentThread.CurrentUICulture = newCulture;
            }
        }

        protected override void OnLoad(EventArgs e)
        {
            base.OnLoad(e);
            base.DataBind();
        }
    }
}
